import { Directive, HostListener, ElementRef, Input } from '@angular/core';
import * as util from '../utils/util';

@Directive({
  selector: '[hover-class]',
  standalone: true
})
export class HoverClassDirective {

  constructor(private elementRef: ElementRef) { }

  @Input('hover-class') hoverClass: string;

  @HostListener('mouseenter') onMouseEnter() {
    this.update('add');
  }

  @HostListener('mouseleave') onMouseLeave() {
    this.update('remove');
  }

  protected update(action: 'add' | 'remove'): void {
    const elem = this.elementRef.nativeElement as HTMLElement;
    this.hoverClass.split(' ').forEach(item => {
      if (!util.isNullOrWhitespace(item))
        elem.classList[action](item);
    });
  }
}
