import { Directive, HostListener, ElementRef, Input } from '@angular/core';

@Directive({
  selector: '[active-class]',
  standalone: true
})
export class ActiveClassDirective {

  constructor(private elementRef: ElementRef) {
  }

  @Input('active-class') activeClass: string;

  @HostListener('mousedown') onMouseDown() {
    this.update('add');
    setTimeout(() => {
      this.update('remove');
    }, 1000);
  }

  @HostListener('mouseup') onMouseUp() {
    this.update('remove');
  }

  protected update(action: 'add' | 'remove'): void {
    const elem = this.elementRef.nativeElement as HTMLElement;
    this.activeClass.split(' ').forEach(item => elem.classList[action](item));
  }
}
