﻿using Serilog;
using Serilog.Context;

namespace Fast.Logic;

public class SerilogPostConfigure
{
    public static void Configure(ApiBehaviorOptions options)
    {
        var builtInFactory = options.InvalidModelStateResponseFactory;

        options.InvalidModelStateResponseFactory = context =>
        {
            if (!context.ModelState.IsValid)
            {
                var appUserId = Util.GetAppUserId(context.HttpContext.User);
                LogContext.PushProperty("UserID", appUserId);

                var message = string.Join(" | ", context.ModelState.Values
                    .SelectMany(v => v.Errors)
                    .Select(e => e.ErrorMessage));
                Log.Error("ModelState: " + message);
            }

            return builtInFactory(context);
        };
    }
}
