using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
public partial class VwRptCounterparty
{
    [Column(TypeName = "citext")]
    public string? Name { get; set; }

    [Column(TypeName = "citext")]
    public string? ShortName { get; set; }

    public DateOnly? InactiveDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Parents { get; set; }

    [Column("Business Type", TypeName = "citext")]
    public string? BusinessType { get; set; }

    [Column("Business SubType", TypeName = "citext")]
    public string? BusinessSubType { get; set; }

    [Column(TypeName = "citext")]
    public string? Relationships { get; set; }

    [Column(TypeName = "citext")]
    public string? Products { get; set; }

    [Column("DUNS", TypeName = "citext")]
    public string? Duns { get; set; }

    [Column(TypeName = "citext")]
    public string? Industry { get; set; }

    [Column("HQ Location", TypeName = "citext")]
    public string? HqLocation { get; set; }

    [Column(TypeName = "citext")]
    public string? Jurisdiction { get; set; }

    [Column(TypeName = "citext")]
    public string? Country { get; set; }

    [Column(TypeName = "citext")]
    public string? AddressLine1 { get; set; }

    [Column(TypeName = "citext")]
    public string? AddressLine2 { get; set; }

    [Column(TypeName = "citext")]
    public string? City { get; set; }

    [Column(TypeName = "citext")]
    public string? State { get; set; }

    [Column(TypeName = "citext")]
    public string? Zip { get; set; }

    [Column(TypeName = "citext")]
    public string? Phone { get; set; }

    [Column(TypeName = "citext")]
    public string? FederalTaxId { get; set; }

    [Column(TypeName = "citext")]
    public string? InternalCustomerNum { get; set; }

    [Column(TypeName = "citext")]
    public string? InternalVendorNum { get; set; }

    [Column(TypeName = "citext")]
    public string? Notes { get; set; }

    public int? CounterpartyId { get; set; }

    [Column(TypeName = "citext")]
    public string? RelationshipIds { get; set; }
}
