using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("transfer_deal")]
public partial class TransferDeal
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("transfer_meter_map_id")]
    public int TransferMeterMapId { get; set; }

    [Column("is_meter1_supply")]
    public bool IsMeter1Supply { get; set; }

    [Column("start_date")]
    public DateOnly StartDate { get; set; }

    [Column("end_date")]
    public DateOnly EndDate { get; set; }

    [Column("ticket_num", TypeName = "citext")]
    public string? TicketNum { get; set; }

    [Column("path_id")]
    public int? PathId { get; set; }

    [Column("path_name", TypeName = "citext")]
    public string? PathName { get; set; }

    [Column("crude_path_id")]
    public int? CrudePathId { get; set; }

    [Column("crude_path_name", TypeName = "citext")]
    public string? CrudePathName { get; set; }

    [InverseProperty("LastTransfer")]
    public virtual ICollection<CrudeActual> CrudeActuals { get; set; } = new List<CrudeActual>();

    [InverseProperty("TransferDeal")]
    public virtual ICollection<CrudeMarket> CrudeMarkets { get; set; } = new List<CrudeMarket>();

    [ForeignKey("CrudePathId")]
    [InverseProperty("TransferDeals")]
    public virtual CrudePath? CrudePath { get; set; }

    [InverseProperty("TransferDeal")]
    public virtual ICollection<CrudeSupply> CrudeSupplies { get; set; } = new List<CrudeSupply>();

    [InverseProperty("LastTransfer")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();

    [InverseProperty("TransferDeal")]
    public virtual ICollection<GasMarket> GasMarkets { get; set; } = new List<GasMarket>();

    [InverseProperty("TransferDeal")]
    public virtual ICollection<GasSupply> GasSupplies { get; set; } = new List<GasSupply>();

    [ForeignKey("PathId")]
    [InverseProperty("TransferDeals")]
    public virtual GasPath? Path { get; set; }

    [InverseProperty("TransferDeal")]
    public virtual ICollection<SosHiddenDeal> SosHiddenDeals { get; set; } = new List<SosHiddenDeal>();

    [ForeignKey("TransferMeterMapId")]
    [InverseProperty("TransferDeals")]
    public virtual TransferMeter TransferMeterMap { get; set; } = null!;
}
