using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("report_data_source")]
[Index("Name", Name = "uk_report_data_source", IsUnique = true)]
public partial class ReportDataSource
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_filter_required")]
    public bool IsFilterRequired { get; set; }

    [InverseProperty("DataSource")]
    public virtual ICollection<ReportFilterParameter> ReportFilterParameters { get; set; } = new List<ReportFilterParameter>();
}
