using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
[Table("product_expiration")]
public partial class ProductExpiration
{
    [Column("contract_month")]
    public DateOnly ContractMonth { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [Column("benchmark_id")]
    public int BenchmarkId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [ForeignKey("BenchmarkId")]
    public virtual Benchmark Benchmark { get; set; } = null!;

    [ForeignKey("ProductId")]
    public virtual Product Product { get; set; } = null!;
}
