using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_tariff_data")]
[Index("TariffId", "SeasonTableId", "SeasonStartDay", "SeasonStartMonth", "ZoneFromId", "ZoneToId", Name = "uk_pipeline_tariff", IsUnique = true)]
public partial class PipelineTariffDatum
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("tariff_id")]
    public int TariffId { get; set; }

    [Column("season_table_id")]
    public int SeasonTableId { get; set; }

    [Column("season_start_day")]
    public int SeasonStartDay { get; set; }

    [Column("season_start_month")]
    public int SeasonStartMonth { get; set; }

    [Column("season_end_day")]
    public int SeasonEndDay { get; set; }

    [Column("season_end_month")]
    public int SeasonEndMonth { get; set; }

    [Column("zone_from_id")]
    public int ZoneFromId { get; set; }

    [Column("zone_to_id")]
    public int ZoneToId { get; set; }

    [Column("rate")]
    public double? Rate { get; set; }

    [ForeignKey("TariffId")]
    [InverseProperty("PipelineTariffData")]
    public virtual PipelineTariff Tariff { get; set; } = null!;
}
