using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("payout_type")]
public partial class PayoutType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [InverseProperty("PayoutType")]
    public virtual ICollection<PlantStatementOption> PlantStatementOptions { get; set; } = new List<PlantStatementOption>();

    [InverseProperty("PayoutType")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();
}
