using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("notification")]
public partial class Notification
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("from_name", TypeName = "citext")]
    public string? FromName { get; set; }

    [Column("from_address", TypeName = "citext")]
    public string? FromAddress { get; set; }

    [Column("to_addresses", TypeName = "citext")]
    public string? ToAddresses { get; set; }

    [Column("subject", TypeName = "citext")]
    public string? Subject { get; set; }

    [Column("body", TypeName = "citext")]
    public string? Body { get; set; }
}
