using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("lease")]
public partial class Lease
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("number", TypeName = "citext")]
    public string? Number { get; set; }

    [Column("lease_type_id")]
    public int LeaseTypeId { get; set; }

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [ForeignKey("LeaseTypeId")]
    [InverseProperty("Leases")]
    public virtual LeaseType LeaseType { get; set; } = null!;

    [InverseProperty("Lease")]
    public virtual ICollection<Meter> Meters { get; set; } = new List<Meter>();
}
