using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("invoice_crude")]
[Index("ContractPaymentTypeId", Name = "ix_invoice_crude_contract_payment_type_id")]
[Index("CounterpartyId", Name = "ix_invoice_crude_counterparty_id")]
[Index("DueDate", Name = "ix_invoice_crude_due_date")]
[Index("EmailedBy", Name = "ix_invoice_crude_emailed_by")]
[Index("EmailedTime", Name = "ix_invoice_crude_emailed_time")]
[Index("InternalEntityId", Name = "ix_invoice_crude_internal_entity_id")]
[Index("InvoiceNum", Name = "ix_invoice_crude_invoice_num")]
[Index("Month", Name = "ix_invoice_crude_month")]
[Index("InvoiceNum", Name = "uk_invoice_crude_invoice_num", IsUnique = true)]
public partial class InvoiceCrude
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("invoice_num", TypeName = "citext")]
    public string InvoiceNum { get; set; } = null!;

    [Column("month")]
    public DateOnly Month { get; set; }

    [Column("internal_entity_id")]
    public int InternalEntityId { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("invoice_type_id")]
    public int InvoiceTypeId { get; set; }

    [Column("due_date")]
    public DateOnly? DueDate { get; set; }

    [Column("contract_payment_type_id")]
    public int? ContractPaymentTypeId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string? FileNameOriginal { get; set; }

    [Column("file_name_on_disk", TypeName = "citext")]
    public string? FileNameOnDisk { get; set; }

    [Column("emailed_by")]
    public int? EmailedBy { get; set; }

    [Column("emailed_time")]
    public DateTime? EmailedTime { get; set; }

    [Column("internal_entity_address_line1", TypeName = "citext")]
    public string? InternalEntityAddressLine1 { get; set; }

    [Column("internal_entity_address_line2", TypeName = "citext")]
    public string? InternalEntityAddressLine2 { get; set; }

    [Column("internal_entity_city", TypeName = "citext")]
    public string? InternalEntityCity { get; set; }

    [Column("internal_entity_zip", TypeName = "citext")]
    public string? InternalEntityZip { get; set; }

    [Column("internal_entity_country_id")]
    public int? InternalEntityCountryId { get; set; }

    [Column("internal_entity_state_id")]
    public int? InternalEntityStateId { get; set; }

    [Column("internal_entity_attn", TypeName = "citext")]
    public string? InternalEntityAttn { get; set; }

    [Column("internal_entity_telephone_num", TypeName = "citext")]
    public string? InternalEntityTelephoneNum { get; set; }

    [Column("internal_entity_fax_num", TypeName = "citext")]
    public string? InternalEntityFaxNum { get; set; }

    [Column("internal_entity_email_address", TypeName = "citext")]
    public string? InternalEntityEmailAddress { get; set; }

    [Column("counterparty_address_line1", TypeName = "citext")]
    public string? CounterpartyAddressLine1 { get; set; }

    [Column("counterparty_address_line2", TypeName = "citext")]
    public string? CounterpartyAddressLine2 { get; set; }

    [Column("counterparty_city", TypeName = "citext")]
    public string? CounterpartyCity { get; set; }

    [Column("counterparty_zip", TypeName = "citext")]
    public string? CounterpartyZip { get; set; }

    [Column("counterparty_country_id")]
    public int? CounterpartyCountryId { get; set; }

    [Column("counterparty_state_id")]
    public int? CounterpartyStateId { get; set; }

    [Column("counterparty_attn", TypeName = "citext")]
    public string? CounterpartyAttn { get; set; }

    [Column("counterparty_telephone_num", TypeName = "citext")]
    public string? CounterpartyTelephoneNum { get; set; }

    [Column("counterparty_fax_num", TypeName = "citext")]
    public string? CounterpartyFaxNum { get; set; }

    [Column("counterparty_email_addresses", TypeName = "citext")]
    public string? CounterpartyEmailAddresses { get; set; }

    [Column("payment_bank_name", TypeName = "citext")]
    public string? PaymentBankName { get; set; }

    [Column("payment_city_state", TypeName = "citext")]
    public string? PaymentCityState { get; set; }

    [Column("payment_aba_num_wire", TypeName = "citext")]
    public string? PaymentAbaNumWire { get; set; }

    [Column("payment_aba_num_ach", TypeName = "citext")]
    public string? PaymentAbaNumAch { get; set; }

    [Column("payment_account_name", TypeName = "citext")]
    public string? PaymentAccountName { get; set; }

    [Column("payment_for_further_credit_to", TypeName = "citext")]
    public string? PaymentForFurtherCreditTo { get; set; }

    [Column("payment_credit_name", TypeName = "citext")]
    public string? PaymentCreditName { get; set; }

    [Column("payment_account_num", TypeName = "citext")]
    public string? PaymentAccountNum { get; set; }

    [Column("subtotal")]
    public decimal? Subtotal { get; set; }

    [Column("sales_tax_rate")]
    public decimal? SalesTaxRate { get; set; }

    [Column("sales_tax_amount")]
    public decimal? SalesTaxAmount { get; set; }

    [Column("grand_total")]
    public decimal? GrandTotal { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("total_quantity")]
    public decimal? TotalQuantity { get; set; }

    [Column("actual_volume")]
    public decimal? ActualVolume { get; set; }

    [Column("usage_diff")]
    public decimal? UsageDiff { get; set; }

    [Column("contact_name", TypeName = "citext")]
    public string? ContactName { get; set; }

    [Column("contact_phone", TypeName = "citext")]
    public string? ContactPhone { get; set; }

    [Column("customer_num", TypeName = "citext")]
    public string? CustomerNum { get; set; }

    [Column("contact_email", TypeName = "citext")]
    public string? ContactEmail { get; set; }

    [Column("invoice_date")]
    public DateOnly InvoiceDate { get; set; }

    [Column("created_by")]
    public int CreatedBy { get; set; }

    [Column("created_time")]
    public DateTime CreatedTime { get; set; }

    [Column("modified_by")]
    public int ModifiedBy { get; set; }

    [Column("modified_time")]
    public DateTime ModifiedTime { get; set; }

    [Column("accounting_contact_name", TypeName = "citext")]
    public string? AccountingContactName { get; set; }

    [Column("accounting_contact_phone", TypeName = "citext")]
    public string? AccountingContactPhone { get; set; }

    [Column("accounting_contact_email", TypeName = "citext")]
    public string? AccountingContactEmail { get; set; }

    [ForeignKey("ContractPaymentTypeId")]
    [InverseProperty("InvoiceCrudes")]
    public virtual ContractPaymentType? ContractPaymentType { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("InvoiceCrudeCounterparties")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("CounterpartyCountryId")]
    [InverseProperty("InvoiceCrudeCounterpartyCountries")]
    public virtual Country? CounterpartyCountry { get; set; }

    [ForeignKey("CounterpartyStateId")]
    [InverseProperty("InvoiceCrudeCounterpartyStates")]
    public virtual Territory? CounterpartyState { get; set; }

    [ForeignKey("CreatedBy")]
    [InverseProperty("InvoiceCrudeCreatedByNavigations")]
    public virtual AppUser CreatedByNavigation { get; set; } = null!;

    [ForeignKey("EmailedBy")]
    [InverseProperty("InvoiceCrudeEmailedByNavigations")]
    public virtual AppUser? EmailedByNavigation { get; set; }

    [ForeignKey("InternalEntityId")]
    [InverseProperty("InvoiceCrudeInternalEntities")]
    public virtual Counterparty InternalEntity { get; set; } = null!;

    [ForeignKey("InternalEntityCountryId")]
    [InverseProperty("InvoiceCrudeInternalEntityCountries")]
    public virtual Country? InternalEntityCountry { get; set; }

    [ForeignKey("InternalEntityStateId")]
    [InverseProperty("InvoiceCrudeInternalEntityStates")]
    public virtual Territory? InternalEntityState { get; set; }

    [InverseProperty("Invoice")]
    public virtual ICollection<InvoiceCrudeLine> InvoiceCrudeLines { get; set; } = new List<InvoiceCrudeLine>();

    [ForeignKey("InvoiceTypeId")]
    [InverseProperty("InvoiceCrudes")]
    public virtual InvoiceType InvoiceType { get; set; } = null!;

    [ForeignKey("ModifiedBy")]
    [InverseProperty("InvoiceCrudeModifiedByNavigations")]
    public virtual AppUser ModifiedByNavigation { get; set; } = null!;
}
