Write-Output "Syncing styles..."

# Define the path to the folder containing the theme files
$folderPath = "./Fast.Web/ClientApp/src/styles"

# Define the file name for the source theme file
$sourceFileName = "theme1.scss"

# Read the contents of the source theme file
$sourceContent = Get-Content "$folderPath\$sourceFileName" -Raw

# Find the index of the start of the generic theme styles
$startIndex = $sourceContent.IndexOf("START OF GENERIC THEME STYLES")

# Extract the generic theme styles from the source file
$genericStyles = $sourceContent.Substring($startIndex)

# Get a list of all the theme files in the folder
$themeFiles = Get-ChildItem "$folderPath\theme*.scss" | Where-Object { $_.Name -ne $sourceFileName }

# Loop through each theme file
foreach ($file in $themeFiles) {
    # Read the contents of the current file
    $content = Get-Content $file.FullName -Raw
  
    # Find the index of the start of the generic theme styles in the current file
    $startIndex = $content.IndexOf("START OF GENERIC THEME STYLES")
  
    # If the start of the generic theme styles is found in the current file
    if ($startIndex -ge 0) {
        # Replace the text in the current file after the start of the generic theme styles with the generic styles from the source file
        $newContent = $content.Substring(0, $startIndex) + $genericStyles
  
        # Replace all instances of "t1" with the appropriate value for the current file
        $themeNumber = [int]($file.Name -replace "theme(\d+)\.scss", '$1')
        $newContent = $newContent -replace "t1", "t$themeNumber"
    
        # Overwrite the current file with the updated content
        $newContent | Set-Content $file.FullName
        Write-Output "Updated $file"
    }
}

Write-Output "Done!"
