$filesToSearch = @("DataHelperSpecific.cs", "RateCalculator.cs", "Test1.cs", "Valuater.cs", "ValuationResult.cs", "Pricer.cs")

foreach ($fileToSearch in $filesToSearch) {
  $files = Get-ChildItem -Path . -Filter $fileToSearch -File -Recurse -ErrorAction SilentlyContinue
  foreach ($file in $files) {
    if ($file) {
      $content = Get-Content -Path $file.FullName -Raw
      #items are duplicated to ensure replacement of windows and unix line endings
      $stringsToReplace = "#define IGNORE_ERROR`r`n", "#define IGNORE_ERROR`n", "#if !IGNORE_ERROR`r`n", "#if !IGNORE_ERROR`n", "`r`n#endif`r`n", "`n#endif`n", "`r`n#endif", "`n#endif"
      foreach ($string in $stringsToReplace) {
        $content = $content -replace [regex]::Escape($string), ""
      }
      Set-Content -Path $file.FullName -Value $content
    }
  }
}
