using Fast.Shared.Logic.FileService;

namespace Test.Shared;

public class SharepointTest
{
    [Test]
    public async Task DeleteSharePointDirectory()
    {
        var config = new FileServiceConfig(GlobalSetup.Env.ContentRootPath);
        config.SharePoint.TenantId = "93e3e76b-c333-4adf-b4b2-4c1b7119c12f";
        config.SharePoint.ClientId = "0061481e-33a5-429b-aaba-b3d76687a497";
        config.SharePoint.ClientSecret = "2pT8Q~3iwCwzW4STRf5k4IP.1NX34fXMYkcIFcsn";
        var fileService = new SharePointFileService(config);

        var folderName = "DealTemplates";
        var files = await fileService.GetFilesAsync(folderName);
        var subDirs = await fileService.GetDirectoriesAsync(folderName);

        if (files.Count == 0 && subDirs.Count == 0)
            await fileService.DeleteDirectoryAsync(folderName);
    }

    [Test]
    public async Task UploadFileToSharepoint()
    {
        var config = new FileServiceConfig(GlobalSetup.Env.ContentRootPath);
        config.SharePoint.TenantId = "93e3e76b-c333-4adf-b4b2-4c1b7119c12f";
        config.SharePoint.ClientId = "0061481e-33a5-429b-aaba-b3d76687a497";
        config.SharePoint.ClientSecret = "2pT8Q~3iwCwzW4STRf5k4IP.1NX34fXMYkcIFcsn";
        var fileService = new SharePointFileService(config);
        var fileName = "TestUpload.txt";
        File.WriteAllText(fileName, "This is test file content created by a unit test.");
        var localFileBytes = File.ReadAllBytes(fileName);
        fileService.WriteAllBytes("ContractTemplates", fileName, localFileBytes, false);
        await Task.CompletedTask;
    }
}

