﻿using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Fast.Models;
public partial class RptCreditLimitRecent
{
    [Column("Approved Date")]
    public DateOnly ApprovedDate { get; set; }
    [Column("Expiration Date")]
    public DateOnly? ExpirationDate { get; set; }
    [Column("Reviewed Date")]
    public DateOnly? ReviewedDate { get; set; }
    [Column("Parent Counterparty")]
    [StringLength(111)]
    public string? ParentCounterparty { get; set; }
    [Column("Total Credit Limit", TypeName = "decimal(19, 0)")]
    public decimal? TotalCreditLimit { get; set; }
    [Column("Approved Credit Limit", TypeName = "decimal(18, 0)")]
    public decimal ApprovedCreditLimit { get; set; }
    [Column("Over Limit Exception?")]
    public bool OverLimitException { get; set; }
    [Column("Exception Amount", TypeName = "decimal(18, 0)")]
    public decimal? ExceptionAmount { get; set; }
    [Column("Exception Expiration")]
    public DateOnly? ExceptionExpiration { get; set; }
    [Column("Counterparty")]
    [StringLength(111)]
    public string? Counterparty { get; set; }
    [Column("Credit Limit", TypeName = "decimal(18, 0)")]
    public decimal? CreditLimit { get; set; }
    [Column("Product Group")]
    [StringLength(50)]
    public string? ProductGroup { get; set; }
    [Column("Collateral Amount", TypeName = "decimal(18, 0)")]
    public decimal? CollateralAmount { get; set; }
    [Column("Collateral Type")]
    [StringLength(40)]
    public string? CollateralType { get; set; }
    [Column("Collateral Expiration Date")]
    [StringLength(100)]
    public DateOnly? CollateralExpirationDate { get; set; }
    [Column("Collateral Expiration Notice")]
    [StringLength(100)]
    public string? CollateralExpirationNotice { get; set; }
}
