﻿using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;

namespace Fast.Web.Logic.ReportSources;

class DailyIndexPrices(MyDbContext context, SpreadsheetDocument wb, string reportName, int dataSourceId, int filterId, string filterName, List<ReportFilterParameter> filterParams, int userInfoId)
    : ReportSourceBase(context, wb, reportName, dataSourceId, filterId, filterName, filterParams, userInfoId)
{

    public override async Task<List<ReportFilterParameter>> Run()
    {
        var query = (from q in db.VwRptDailyIndexPrices select q);

        string paramName;

        paramName = "Price Index";
        if (HasParam(paramName))
        {
            await FixInvalidFilterParams(paramName);
            var idList = GetIdList(paramName);
            query = query.Where(x => x.IndexId.HasValue && idList.Contains(x.IndexId.Value));
        }

        paramName = "Price Date";
        if (HasParam(paramName))
        {
            var exp = GetDateRangeExpression<VwRptDailyIndexPrice>(paramName, "PriceDate", false);
            query = query.Where(exp);
        }

        paramName = "Contract Month";
        if (HasParam(paramName))
        {
            var exp = GetDateRangeExpression<VwRptDailyIndexPrice>(paramName, "ContractMonth", false);
            query = query.Where(exp);
        }

        query = query.OrderBy(x => x.PriceDate);

        var result = await query.ToListAsync();
        FillSheet("Daily Index Price", result);

        return GetNewFilterParams();
    }
}
