﻿using System.Data;

namespace Fast.Web.Logic.GasControl
{
    public class GasTrackFileCreator
    {
        private DataTable dt = new();
        private readonly Dictionary<string, GasTrackFieldAttribute> FieldLengths = new();

        public GasTrackFileCreator()
        {
            SetFieldLengths();
        }

        private void SetFieldLengths()
        {
            const int ContractNumLen = 20;
            const int PointLen = 15;
            const int PipeLen = 20;
            const int TransRateLen = 15;
            const int FuelRateLen = 14;
            const int EntityLen = 50;
            const int TransferNum = 9;

            FieldLengths.Add("BOT_DEAL#", new GasTrackFieldAttribute(10, FieldType.Alpha));
            FieldLengths.Add("VENDOR#", new GasTrackFieldAttribute(5, FieldType.Numeric));
            FieldLengths.Add("TYPE", new GasTrackFieldAttribute(1, FieldType.Alpha));
            FieldLengths.Add("PIPELINE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("CONTRACT #", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TRADER", new GasTrackFieldAttribute(4, FieldType.Alpha));
            FieldLengths.Add("TRADE_DATE", new GasTrackFieldAttribute(8, FieldType.Numeric));
            FieldLengths.Add("START_DATE", new GasTrackFieldAttribute(8, FieldType.Numeric));
            FieldLengths.Add("END_DATE", new GasTrackFieldAttribute(8, FieldType.Numeric));
            FieldLengths.Add("VOLUME", new GasTrackFieldAttribute(8, FieldType.Numeric));
            FieldLengths.Add("INV_PRICE", new GasTrackFieldAttribute(10, FieldType.Numeric));
            FieldLengths.Add("PRICE_TYPE", new GasTrackFieldAttribute(1, FieldType.Numeric));
            FieldLengths.Add("PREM/DISC", new GasTrackFieldAttribute(10, FieldType.Numeric));
            FieldLengths.Add("PRICE", new GasTrackFieldAttribute(10, FieldType.Numeric));
            FieldLengths.Add("INDEX", new GasTrackFieldAttribute(20, FieldType.Alpha));
            FieldLengths.Add("INT_ENTITY", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TRANS_RATE", new GasTrackFieldAttribute(10, FieldType.Numeric));
            FieldLengths.Add("FUEL_RATE", new GasTrackFieldAttribute(10, FieldType.Numeric));
            FieldLengths.Add("OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TSF1", new GasTrackFieldAttribute(TransferNum, FieldType.Numeric));
            FieldLengths.Add("TSF1_OUT_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF1_IN_PIPE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("TSF1_IN_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF1_IN_CONTRACT#", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TSF1_TRANS_RATE", new GasTrackFieldAttribute(TransRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF1_FUEL_RATE", new GasTrackFieldAttribute(FuelRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF1_OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TSF2", new GasTrackFieldAttribute(TransferNum, FieldType.Numeric));
            FieldLengths.Add("TSF2_OUT_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF2_IN_PIPE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("TSF2_IN_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF2_IN_CONTRACT#", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TSF2_TRANS_RATE", new GasTrackFieldAttribute(TransRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF2_FUEL_RATE", new GasTrackFieldAttribute(FuelRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF2_OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TSF3", new GasTrackFieldAttribute(TransferNum, FieldType.Numeric));
            FieldLengths.Add("TSF3_OUT_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF3_IN_PIPE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("TSF3_IN_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF3_IN_CONTRACT#", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TSF3_TRANS_RATE", new GasTrackFieldAttribute(TransRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF3_FUEL_RATE", new GasTrackFieldAttribute(FuelRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF3_OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TSF4", new GasTrackFieldAttribute(TransferNum, FieldType.Numeric));
            FieldLengths.Add("TSF4_OUT_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF4_IN_PIPE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("TSF4_IN_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF4_IN_CONTRACT#", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TSF4_TRANS_RATE", new GasTrackFieldAttribute(TransRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF4_FUEL_RATE", new GasTrackFieldAttribute(FuelRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF4_OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("TSF5", new GasTrackFieldAttribute(TransferNum, FieldType.Numeric));
            FieldLengths.Add("TSF5_OUT_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF5_IN_PIPE", new GasTrackFieldAttribute(PipeLen, FieldType.Alpha));
            FieldLengths.Add("TSF5_IN_POINT", new GasTrackFieldAttribute(PointLen, FieldType.Alpha));
            FieldLengths.Add("TSF5_IN_CONTRACT#", new GasTrackFieldAttribute(ContractNumLen, FieldType.Alpha));
            FieldLengths.Add("TSF5_TRANS_RATE", new GasTrackFieldAttribute(TransRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF5_FUEL_RATE", new GasTrackFieldAttribute(FuelRateLen, FieldType.Numeric));
            FieldLengths.Add("TSF5_OWNERSHIP", new GasTrackFieldAttribute(EntityLen, FieldType.Alpha));
            FieldLengths.Add("SELL_DEAL#", new GasTrackFieldAttribute(10, FieldType.Alpha));
            FieldLengths.Add("GASTRACK#", new GasTrackFieldAttribute(10, FieldType.Alpha));
            FieldLengths.Add("CUSTOMER#", new GasTrackFieldAttribute(5, FieldType.Numeric));
        }

        public MemoryStream CreateMemoryStream(List<GasTrackExportItem> GasExportItems)
        {
            CreateDataTable();
            FillDataTable(GasExportItems);
            var stream = GasTrackHelper.CreateGasTrackFile(dt, FieldLengths, true);

            return stream;
        }

        private void CreateDataTable()
        {
            dt = new DataTable();
            dt.Columns.Add(new DataColumn() { ColumnName = "bBOT_DEAL#", Caption = "BOT_DEAL#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bVENDOR#", Caption = "VENDOR#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bTYPE", Caption = "TYPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bPIPELINE", Caption = "PIPELINE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bPOINT", Caption = "POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bCONTRACT #", Caption = "CONTRACT #" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bTRADER", Caption = "TRADER" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bTRADE_DATE", Caption = "TRADE_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bSTART_DATE", Caption = "START_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bEND_DATE", Caption = "END_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bVOLUME", Caption = "VOLUME" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bINV_PRICE", Caption = "INV_PRICE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bPRICE_TYPE", Caption = "PRICE_TYPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bPREM/DISC", Caption = "PREM/DISC" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bPRICE", Caption = "PRICE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bINDEX", Caption = "INDEX" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bINT_ENTITY", Caption = "INT_ENTITY" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bTRANS_RATE", Caption = "TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bFUEL_RATE", Caption = "FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "bOWNERSHIP", Caption = "OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1", Caption = "TSF1" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_OUT_POINT", Caption = "TSF1_OUT_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_IN_PIPE", Caption = "TSF1_IN_PIPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_IN_POINT", Caption = "TSF1_IN_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_IN_CONTRACT#", Caption = "TSF1_IN_CONTRACT#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_TRANS_RATE", Caption = "TSF1_TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_FUEL_RATE", Caption = "TSF1_FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF1_OWNERSHIP", Caption = "TSF1_OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2", Caption = "TSF2" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_OUT_POINT", Caption = "TSF2_OUT_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_IN_PIPE", Caption = "TSF2_IN_PIPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_IN_POINT", Caption = "TSF2_IN_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_IN_CONTRACT#", Caption = "TSF2_IN_CONTRACT#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_TRANS_RATE", Caption = "TSF2_TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_FUEL_RATE", Caption = "TSF2_FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF2_OWNERSHIP", Caption = "TSF2_OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3", Caption = "TSF3" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_OUT_POINT", Caption = "TSF3_OUT_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_IN_PIPE", Caption = "TSF3_IN_PIPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_IN_POINT", Caption = "TSF3_IN_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_IN_CONTRACT#", Caption = "TSF3_IN_CONTRACT#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_TRANS_RATE", Caption = "TSF3_TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_FUEL_RATE", Caption = "TSF3_FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF3_OWNERSHIP", Caption = "TSF3_OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4", Caption = "TSF4" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_OUT_POINT", Caption = "TSF4_OUT_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_IN_PIPE", Caption = "TSF4_IN_PIPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_IN_POINT", Caption = "TSF4_IN_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_IN_CONTRACT#", Caption = "TSF4_IN_CONTRACT#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_TRANS_RATE", Caption = "TSF4_TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_FUEL_RATE", Caption = "TSF4_FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF4_OWNERSHIP", Caption = "TSF4_OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5", Caption = "TSF5" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_OUT_POINT", Caption = "TSF5_OUT_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_IN_PIPE", Caption = "TSF5_IN_PIPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_IN_POINT", Caption = "TSF5_IN_POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_IN_CONTRACT#", Caption = "TSF5_IN_CONTRACT#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_TRANS_RATE", Caption = "TSF5_TRANS_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_FUEL_RATE", Caption = "TSF5_FUEL_RATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "TSF5_OWNERSHIP", Caption = "TSF5_OWNERSHIP" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sSELL_DEAL#", Caption = "SELL_DEAL#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sGASTRACK#", Caption = "GASTRACK#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sCUSTOMER#", Caption = "CUSTOMER#" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sTYPE", Caption = "TYPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sPIPELINE", Caption = "PIPELINE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sPOINT", Caption = "POINT" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sCONTRACT #", Caption = "CONTRACT #" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sTRADER", Caption = "TRADER" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sTRADE_DATE", Caption = "TRADE_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sSTART_DATE", Caption = "START_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sEND_DATE", Caption = "END_DATE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sVOLUME", Caption = "VOLUME" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sINV_PRICE", Caption = "INV_PRICE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sPRICE_TYPE", Caption = "PRICE_TYPE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sPREM/DISC", Caption = "PREM/DISC" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sPRICE", Caption = "PRICE" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sINDEX", Caption = "INDEX" });
            dt.Columns.Add(new DataColumn() { ColumnName = "sINT_ENTITY", Caption = "INT_ENTITY" });
        }

        private void FillDataTable(List<GasTrackExportItem> GasExportItems)
        {
            foreach (GasTrackExportItem gei in GasExportItems)
            {
                DataRow dr = dt.NewRow();
                dr["bBOT_DEAL#"] = gei.bBOT_DEAL;
                dr["bVENDOR#"] = gei.bVENDOR;
                dr["bTYPE"] = gei.bTYPE;
                dr["bPIPELINE"] = gei.bPIPELINE;
                dr["bPOINT"] = gei.bPOINT;
                dr["bCONTRACT #"] = gei.bCONTRACT;
                dr["bTRADER"] = gei.bTRADER;
                dr["bTRADE_DATE"] = gei.bTRADE_DATE;
                dr["bSTART_DATE"] = gei.bSTART_DATE;
                dr["bEND_DATE"] = gei.bEND_DATE;
                dr["bVOLUME"] = gei.bVOLUME;
                dr["bINV_PRICE"] = gei.bINV_PRICE;
                dr["bPRICE_TYPE"] = gei.bPRICE_TYPE;
                dr["bPREM/DISC"] = gei.bPREMDISC;
                dr["bPRICE"] = gei.bPRICE;
                dr["bINDEX"] = gei.bINDEX;
                dr["bINT_ENTITY"] = gei.bINT_ENTITY;
                dr["bTRANS_RATE"] = gei.bTRANS_RATE;
                dr["bFUEL_RATE"] = gei.bFUEL_RATE;
                dr["bOWNERSHIP"] = gei.bOWNERSHIP;
                dr["TSF1"] = gei.TSF1;
                dr["TSF1_OUT_POINT"] = gei.TSF1_OUT_POINT;
                dr["TSF1_IN_PIPE"] = gei.TSF1_IN_PIPE;
                dr["TSF1_IN_POINT"] = gei.TSF1_IN_POINT;
                dr["TSF1_IN_CONTRACT#"] = gei.TSF1_IN_CONTRACT;
                dr["TSF1_TRANS_RATE"] = gei.TSF1_TRANS_RATE;
                dr["TSF1_FUEL_RATE"] = gei.TSF1_FUEL_RATE;
                dr["TSF1_OWNERSHIP"] = gei.TSF1_OWNERSHIP;
                dr["TSF2"] = gei.TSF2;
                dr["TSF2_OUT_POINT"] = gei.TSF2_OUT_POINT;
                dr["TSF2_IN_PIPE"] = gei.TSF2_IN_PIPE;
                dr["TSF2_IN_POINT"] = gei.TSF2_IN_POINT;
                dr["TSF2_IN_CONTRACT#"] = gei.TSF2_IN_CONTRACT;
                dr["TSF2_TRANS_RATE"] = gei.TSF2_TRANS_RATE;
                dr["TSF2_FUEL_RATE"] = gei.TSF2_FUEL_RATE;
                dr["TSF2_OWNERSHIP"] = gei.TSF2_OWNERSHIP;
                dr["TSF3"] = gei.TSF3;
                dr["TSF3_OUT_POINT"] = gei.TSF3_OUT_POINT;
                dr["TSF3_IN_PIPE"] = gei.TSF3_IN_PIPE;
                dr["TSF3_IN_POINT"] = gei.TSF3_IN_POINT;
                dr["TSF3_IN_CONTRACT#"] = gei.TSF3_IN_CONTRACT;
                dr["TSF3_TRANS_RATE"] = gei.TSF3_TRANS_RATE;
                dr["TSF3_FUEL_RATE"] = gei.TSF3_FUEL_RATE;
                dr["TSF3_OWNERSHIP"] = gei.TSF3_OWNERSHIP;
                dr["TSF4"] = gei.TSF4;
                dr["TSF4_OUT_POINT"] = gei.TSF4_OUT_POINT;
                dr["TSF4_IN_PIPE"] = gei.TSF4_IN_PIPE;
                dr["TSF4_IN_POINT"] = gei.TSF4_IN_POINT;
                dr["TSF4_IN_CONTRACT#"] = gei.TSF4_IN_CONTRACT;
                dr["TSF4_TRANS_RATE"] = gei.TSF4_TRANS_RATE;
                dr["TSF4_FUEL_RATE"] = gei.TSF4_FUEL_RATE;
                dr["TSF4_OWNERSHIP"] = gei.TSF4_OWNERSHIP;
                dr["TSF5"] = gei.TSF5;
                dr["TSF5_OUT_POINT"] = gei.TSF5_OUT_POINT;
                dr["TSF5_IN_PIPE"] = gei.TSF5_IN_PIPE;
                dr["TSF5_IN_POINT"] = gei.TSF5_IN_POINT;
                dr["TSF5_IN_CONTRACT#"] = gei.TSF5_IN_CONTRACT;
                dr["TSF5_TRANS_RATE"] = gei.TSF5_TRANS_RATE;
                dr["TSF5_FUEL_RATE"] = gei.TSF5_FUEL_RATE;
                dr["TSF5_OWNERSHIP"] = gei.TSF5_OWNERSHIP;
                dr["sSELL_DEAL#"] = gei.sSELL_DEAL;
                dr["sGASTRACK#"] = gei.sGASTRACK;
                dr["sCUSTOMER#"] = gei.sCUSTOMER;
                dr["sTYPE"] = gei.sTYPE;
                dr["sPIPELINE"] = gei.sPIPELINE;
                dr["sPOINT"] = gei.sPOINT;
                dr["sCONTRACT #"] = gei.sCONTRACT;
                dr["sTRADER"] = gei.sTRADER;
                dr["sTRADE_DATE"] = gei.sTRADE_DATE;
                dr["sSTART_DATE"] = gei.sSTART_DATE;
                dr["sEND_DATE"] = gei.sEND_DATE;
                dr["sVOLUME"] = gei.sVOLUME;
                dr["sINV_PRICE"] = gei.sINV_PRICE;
                dr["sPRICE_TYPE"] = gei.sPRICE_TYPE;
                dr["sPREM/DISC"] = gei.sPREMDISC;
                dr["sPRICE"] = gei.sPRICE;
                dr["sINDEX"] = gei.sINDEX;
                dr["sINT_ENTITY"] = gei.sINT_ENTITY;
                dt.Rows.Add(dr);
            }
        }
    }
}