import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";
import { ControlProductComponent } from "../../filter-controls/control-product/control-product.component";
import { ControlCounterpartyComponent } from "../../filter-controls/control-counterparty/control-counterparty.component";
import { ControlPipelineComponent } from "../../filter-controls/control-pipeline/control-pipeline.component";
import { ControlMeterComponent } from "../../filter-controls/control-meter/control-meter.component";

@Component({
  selector: 'datasource-valuation-data-by-path',
  templateUrl: './datasource-valuation-data-by-path.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlDateRangeComponent,
    ControlProductComponent,
    ControlCounterpartyComponent,
    ControlPipelineComponent, ControlMeterComponent]
})
export class DatasourceValuationDataByPathComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
