import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlBookComponent } from "../../filter-controls/control-book/control-book.component";
import { ControlBuySellComponent } from "../../filter-controls/control-buy-sell/control-buy-sell.component";
import { ControlCounterpartyComponent } from "../../filter-controls/control-counterparty/control-counterparty.component";
import { ControlDealPurposeComponent } from "../../filter-controls/control-deal-purpose/control-deal-purpose.component";
import { ControlDealTypeComponent } from "../../filter-controls/control-deal-type/control-deal-type.component";
import { ControlInternalEntityComponent } from "../../filter-controls/control-internal-entity/control-internal-entity.component";
import { ControlPipelineComponent } from "../../filter-controls/control-pipeline/control-pipeline.component";
import { ControlPointComponent } from "../../filter-controls/control-point/control-point.component";
import { ControlPortfolioComponent } from "../../filter-controls/control-portfolio/control-portfolio.component";
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";
import { ControlRegionComponent } from "../../filter-controls/control-region/control-region.component";
import { ControlStrategyComponent } from "../../filter-controls/control-strategy/control-strategy.component";
import { ControlTraderComponent } from "../../filter-controls/control-trader/control-trader.component";
import { ControlTransactionTypeComponent } from "../../filter-controls/control-transaction-type/control-transaction-type.component";

@Component({
  selector: 'datasource-trades',
  templateUrl: './datasource-trades.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlBookComponent,
    ControlBuySellComponent,
    ControlCounterpartyComponent,
    ControlDealPurposeComponent,
    ControlDealTypeComponent,
    ControlInternalEntityComponent,
    ControlPipelineComponent,
    ControlPointComponent,
    ControlPortfolioComponent,
    ControlDateRangeComponent,
    ControlRegionComponent,
    ControlStrategyComponent,
    ControlTraderComponent,
    ControlTransactionTypeComponent
  ]
})
export class DatasourceTradesComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
