import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";
import { ControlLeaseComponent } from "../../filter-controls/control-lease/control-lease.component";
import { ControlCounterpartyComponent } from "../../filter-controls/control-counterparty/control-counterparty.component";
import { ControlMeterComponent } from "../../filter-controls/control-meter/control-meter.component";
import { ControlPipelineComponent } from "../../filter-controls/control-pipeline/control-pipeline.component";

@Component({
  selector: 'datasource-scheduling-data',
  templateUrl: './datasource-scheduling-data.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlDateRangeComponent,
    ControlLeaseComponent,
    ControlCounterpartyComponent,
    ControlMeterComponent,
    ControlPipelineComponent
  ]
})
export class DatasourceSchedulingDataComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
