import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlMeterComponent } from "../../filter-controls/control-meter/control-meter.component";
import { ControlPlantComponent } from "../../filter-controls/control-plant/control-plant.component";
import { ControlProducerComponent } from "../../filter-controls/control-producer/control-producer.component";
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";

@Component({
  selector: 'datasource-plant-statements',
  templateUrl: './datasource-plant-statements.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlMeterComponent,
    ControlPlantComponent,
    ControlProducerComponent,
    ControlDateRangeComponent
  ]
})
export class DatasourcePlantStatementsComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
