import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";
import { ControlPriceIndexComponent } from "../../filter-controls/control-price-index/control-price-index.component";

@Component({
  selector: 'datasource-monthly-index-prices',
  templateUrl: './datasource-monthly-index-prices.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlDateRangeComponent,
    ControlPriceIndexComponent
  ]
})
export class DatasourceMonthlyIndexPricesComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
