import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlActiveComponent } from "../../filter-controls/control-active/control-active.component";
import { ControlPointComponent } from "../../filter-controls/control-point/control-point.component";
import { ControlProductComponent } from "../../filter-controls/control-product/control-product.component";

@Component({
  selector: 'datasource-meter-data',
  templateUrl: './datasource-meter-data.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlActiveComponent,
    ControlPointComponent,
    ControlProductComponent
  ]
})
export class DatasourceMeterDataComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
