import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlDateRangeComponent } from "../../filter-controls/control-date-range/control-date-range.component";
import { ControlCounterpartyComponent } from "../../filter-controls/control-counterparty/control-counterparty.component";
import { ControlProductGroupComponent } from "../../filter-controls/control-product-group/control-product-group.component";

@Component({
  selector: 'datasource-credit-limits',
  templateUrl: './datasource-credit-limits.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlDateRangeComponent,
    ControlCounterpartyComponent,
    ControlProductGroupComponent
  ]
})
export class DatasourceCreditLimitsComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
