import { Component, ViewEncapsulation, ChangeDetectionStrategy } from '@angular/core';
import { DatasourceBaseComponent } from '../datasource-base.component';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { ControlCounterpartyComponent } from "../../filter-controls/control-counterparty/control-counterparty.component";
import { ControlActiveComponent } from "../../filter-controls/control-active/control-active.component";
import { ControlRelationshipComponent } from "../../filter-controls/control-relationship/control-relationship.component";

@Component({
  selector: 'datasource-counterparty-data',
  templateUrl: './datasource-counterparty-data.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON,
    ControlCounterpartyComponent,
    ControlActiveComponent,
    ControlRelationshipComponent
  ]
})
export class DatasourceCounterpartyDataComponent extends DatasourceBaseComponent {
  constructor() {
    super();
  }
}
