import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { IdName } from '../_shared/utils/util';
import { shareReplay } from 'rxjs/operators';

@Injectable({
  providedIn: 'root'
})
export class FilterControlService {
  private baseUrl = `${window.location.origin}/api/FilterControl`;
  private http = inject(HttpClient);

  leases$ = this.http.get<IdName[]>(`${this.baseUrl}/GetLeases`).pipe(shareReplay(1))

  books$ = this.http.get<IdName[]>(`${this.baseUrl}/GetBooks`).pipe(shareReplay(1))

  brokers$ = this.http.get<IdName[]>(`${this.baseUrl}/GetBrokers`).pipe(shareReplay(1))

  brokerAccounts$ = this.http.get<IdName[]>(`${this.baseUrl}/GetBrokerAccounts`).pipe(shareReplay(1))

  products$ = this.http.get<IdName[]>(`${this.baseUrl}/GetProducts`).pipe(shareReplay(1))

  counterparties$ = this.http.get<IdName[]>(`${this.baseUrl}/GetCounterparties`).pipe(shareReplay(1))

  dealPurposes$ = this.http.get<IdName[]>(`${this.baseUrl}/GetDealPurposes`).pipe(shareReplay(1))

  dealStatuses$ = this.http.get<IdName[]>(`${this.baseUrl}/GetDealStatuses`).pipe(shareReplay(1))

  dealTypes$ = this.http.get<IdName[]>(`${this.baseUrl}/GetDealTypes`).pipe(shareReplay(1))

  internalEntities$ = this.http.get<IdName[]>(`${this.baseUrl}/GetInternalEntities`).pipe(shareReplay(1))

  internalEntitiesOld$ = this.http.get<IdName[]>(`${this.baseUrl}/GetInternalEntitiesOld`).pipe(shareReplay(1))

  meters$ = this.http.get<IdName[]>(`${this.baseUrl}/GetMeters`).pipe(shareReplay(1))

  pipelines$ = this.http.get<IdName[]>(`${this.baseUrl}/GetPipelines`).pipe(shareReplay(1))

  plants$ = this.http.get<IdName[]>(`${this.baseUrl}/GetPlants`).pipe(shareReplay(1))

  points$ = this.http.get<IdName[]>(`${this.baseUrl}/GetPoints`).pipe(shareReplay(1))

  portfolios$ = this.http.get<IdName[]>(`${this.baseUrl}/GetPortfolios`).pipe(shareReplay(1))

  priceIndexes$ = this.http.get<IdName[]>(`${this.baseUrl}/GetPriceIndexes`).pipe(shareReplay(1))

  producers$ = this.http.get<IdName[]>(`${this.baseUrl}/GetProducers`).pipe(shareReplay(1))

  productGroups$ = this.http.get<IdName[]>(`${this.baseUrl}/GetProductGroups`).pipe(shareReplay(1))

  regions$ = this.http.get<IdName[]>(`${this.baseUrl}/GetRegions`).pipe(shareReplay(1))

  relationships$ = this.http.get<IdName[]>(`${this.baseUrl}/GetRelationships`).pipe(shareReplay(1))

  strategies$ = this.http.get<IdName[]>(`${this.baseUrl}/GetStrategies`).pipe(shareReplay(1))

  traders$ = this.http.get<IdName[]>(`${this.baseUrl}/GetTraders`).pipe(shareReplay(1))

  transactionTypes$ = this.http.get<IdName[]>(`${this.baseUrl}/GetTransactionTypes`).pipe(shareReplay(1))

  utilities$ = this.http.get<IdName[]>(`${this.baseUrl}/GetUtilities`).pipe(shareReplay(1))
}
