import { CdkAccordion } from '@angular/cdk/accordion';
import { ChangeDetectionStrategy, Component, input, computed, output } from '@angular/core';

@Component({
  selector: 'fast-panelbar',
  template: `
  <ng-content [disabled]="disabled()" select="fast-panelbar-item"></ng-content>
  `,
  styles: ``,
  changeDetection: ChangeDetectionStrategy.OnPush,
  host: {
    '[class]': 'this.conditionalClasses()',
  },
})
export class FastPanelbarComponent extends CdkAccordion {
  disabled = input<boolean>(false);

  expand = output<unknown>();
  collapse = output<unknown>();
  // eslint-disable-next-line @angular-eslint/no-output-native
  select = output<unknown>();

  conditionalClasses = computed(() => {
    const classes = [] as string[];

    classes.push(...this.getCommonClasses());
    classes.push(...this.getLightBaseClasses());
    classes.push(...this.getDarkBaseClasses());

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });

  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  getCommonClasses() {
    const commonClasses = [] as string[];
    commonClasses.push(
      "flex",
      "flex-col",
      "grow",
      "border-2",
      "w-full",
    );
    return commonClasses;
  }

  getLightBaseClasses() {
    const lightBase = [
      "bg-base-white-500",
      "text-base-black-1000",
      "border-base-black-1000"]

    return lightBase;
  }

  getDarkBaseClasses() {
    const darkBase = [
      "dark:bg-alt-gray-500",
      "dark:text-base-white-500",
      "dark:border-base-white-250"]
    return darkBase;
  }
}
