namespace Fast.Shared.Models;

[Serializable]
public class IdDate : IEquatable<IdDate>
{
    public int Id;
    public DateTime? Date;

    public IdDate()
    {
    }

    public IdDate(int Id, DateTime? Date)
    {
        this.Id = Id;
        this.Date = Date;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdDate);
    }

    public bool Equals(IdDate? other)
    {
        return Id == other?.Id &&
               Date == other?.Date;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(Id, Date);
    }

    public static bool operator ==(IdDate pair1, IdDate pair2)
    {
        return EqualityComparer<IdDate>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(IdDate pair1, IdDate pair2)
    {
        return !(pair1 == pair2);
    }
}
