namespace Fast.Shared.Logic.ValuationCommon;

[Serializable]
public class ValPriceKey : IEquatable<ValPriceKey>
{
    public int IndexId;
    public DateOnly Date;
    public Enums.ValPriceType PriceType;

    public ValPriceKey()
    {
    }

    public ValPriceKey(int IndexId, DateOnly Date, Enums.ValPriceType PriceType)
    {
        this.IndexId = IndexId;
        this.Date = Date;
        this.PriceType = PriceType;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdNameActive);
    }

    public bool Equals(ValPriceKey? other)
    {
        return IndexId == other?.IndexId &&
               Date == other?.Date &&
               PriceType == other?.PriceType;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(IndexId, Date, PriceType);
    }

    public static bool operator ==(ValPriceKey pair1, ValPriceKey pair2)
    {
        return EqualityComparer<ValPriceKey>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(ValPriceKey pair1, ValPriceKey pair2)
    {
        return !(pair1 == pair2);
    }
}
