using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Keyless]
public partial class VwValDeal
{
    [Column("id")]
    public int? Id { get; set; }

    [Column("ticket_num", TypeName = "citext")]
    public string? TicketNum { get; set; }

    [Column("master_ticket_num", TypeName = "citext")]
    public string? MasterTicketNum { get; set; }

    [Column("master_deal_id")]
    public int? MasterDealId { get; set; }

    [Column("start_date")]
    public DateOnly? StartDate { get; set; }

    [Column("end_date")]
    public DateOnly? EndDate { get; set; }

    [Column("trading_date")]
    public DateOnly? TradingDate { get; set; }

    [Column("accounting_month")]
    public DateOnly? AccountingMonth { get; set; }

    [Column("buy_button")]
    public int? BuyButton { get; set; }

    [Column("hypothetical_id")]
    public int? HypotheticalId { get; set; }

    [Column("settle_type_id")]
    public int? SettleTypeId { get; set; }

    [Column("transaction_type_id")]
    public int? TransactionTypeId { get; set; }

    [Column("volume")]
    public double? Volume { get; set; }

    [Column("volume_type_id")]
    public int? VolumeTypeId { get; set; }

    [Column("is_variable_volume")]
    public bool? IsVariableVolume { get; set; }

    [Column("num_of_contracts")]
    public int? NumOfContracts { get; set; }

    [Column("fixed_price")]
    public double? FixedPrice { get; set; }

    [Column("fixed_price_button")]
    public int? FixedPriceButton { get; set; }

    [Column("tn_e_fuel_percent", TypeName = "citext")]
    public string? TnEFuelPercent { get; set; }

    [Column("tn_e_expense", TypeName = "citext")]
    public string? TnEExpense { get; set; }

    [Column("premium_or_discount")]
    public double? PremiumOrDiscount { get; set; }

    [Column("basis")]
    public double? Basis { get; set; }

    [Column("is_pooled_future_deal")]
    public int? IsPooledFutureDeal { get; set; }

    [Column("tax_credit")]
    public double? TaxCredit { get; set; }

    [Column("price_index_id")]
    public int? PriceIndexId { get; set; }

    [Column("price_index_type")]
    public int? PriceIndexType { get; set; }

    [Column("price_index_id2")]
    public int? PriceIndexId2 { get; set; }

    [Column("price_index_type2")]
    public int? PriceIndexType2 { get; set; }

    [Column("market_posting_index_id")]
    public int? MarketPostingIndexId { get; set; }

    [Column("market_posting_index_type")]
    public int? MarketPostingIndexType { get; set; }

    [Column("unit_of_measure_id")]
    public int? UnitOfMeasureId { get; set; }

    [Column("unit_basis_price_id")]
    public int? UnitBasisPriceId { get; set; }

    [Column("unit_fixed_price_id")]
    public int? UnitFixedPriceId { get; set; }

    [Column("unit_prem_disc_price_id")]
    public int? UnitPremDiscPriceId { get; set; }

    [Column("unit_of_commodity_measure_id")]
    public int? UnitOfCommodityMeasureId { get; set; }

    [Column("unit_commodity_price_id")]
    public int? UnitCommodityPriceId { get; set; }

    [Column("unit_tax_credit_id")]
    public int? UnitTaxCreditId { get; set; }

    [Column("cost_execution_margin")]
    public double? CostExecutionMargin { get; set; }

    [Column("cost_sales_margin")]
    public double? CostSalesMargin { get; set; }

    [Column("cost_nymex_execution")]
    public double? CostNymexExecution { get; set; }

    [Column("book_id")]
    public int? BookId { get; set; }

    [Column("broker_id")]
    public int? BrokerId { get; set; }

    [Column("broker_account_id")]
    public int? BrokerAccountId { get; set; }

    [Column("counterparty_id")]
    public int? CounterpartyId { get; set; }

    [Column("deal_purpose_id")]
    public int? DealPurposeId { get; set; }

    [Column("deal_status_id")]
    public int? DealStatusId { get; set; }

    [Column("internal_entity_id")]
    public int? InternalEntityId { get; set; }

    [Column("physical_deal_type_id")]
    public int? PhysicalDealTypeId { get; set; }

    [Column("pipeline_id")]
    public int? PipelineId { get; set; }

    [Column("pipeline_source_delivery_id")]
    public int? PipelineSourceDeliveryId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("portfolio_id")]
    public int? PortfolioId { get; set; }

    [Column("product_id")]
    public int? ProductId { get; set; }

    [Column("product_category_id")]
    public int? ProductCategoryId { get; set; }

    [Column("region_id")]
    public int? RegionId { get; set; }

    [Column("strategy_id")]
    public int? StrategyId { get; set; }

    [Column("trader_id")]
    public int? TraderId { get; set; }

    [Column("wasp_num", TypeName = "citext")]
    public string? WaspNum { get; set; }
}
