using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Keyless]
public partial class VwCreditLimitCollateralOverview
{
    [Column("id")]
    public int? Id { get; set; }

    [Column("credit_limit_counterparty_id")]
    public int? CreditLimitCounterpartyId { get; set; }

    [Column("collateral_amount")]
    public decimal? CollateralAmount { get; set; }

    [Column("collateral_type_id")]
    public int? CollateralTypeId { get; set; }

    [Column("effective_date")]
    public DateOnly? EffectiveDate { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [Column("expiration_notice", TypeName = "citext")]
    public string? ExpirationNotice { get; set; }

    [Column("beneficiaries", TypeName = "citext")]
    public string? Beneficiaries { get; set; }

    [Column("providers", TypeName = "citext")]
    public string? Providers { get; set; }
}
