using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("transaction_type")]
public partial class TransactionType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("deal_ticket_prefix", TypeName = "citext")]
    public string? DealTicketPrefix { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [InverseProperty("TransactionType")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();

    [InverseProperty("TransactionType")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();
}
