using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("territory")]
public partial class Territory
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("abbreviation", TypeName = "citext")]
    public string? Abbreviation { get; set; }

    [Column("code", TypeName = "citext")]
    public string? Code { get; set; }

    [InverseProperty("AchState")]
    public virtual ICollection<BankRouting> BankRoutingAchStates { get; set; } = new List<BankRouting>();

    [InverseProperty("WireState")]
    public virtual ICollection<BankRouting> BankRoutingWireStates { get; set; } = new List<BankRouting>();

    [InverseProperty("BrokerState")]
    public virtual ICollection<Broker> Brokers { get; set; } = new List<Broker>();

    [InverseProperty("State")]
    public virtual ICollection<Contact> Contacts { get; set; } = new List<Contact>();

    [InverseProperty("ChecksState")]
    public virtual ICollection<ContractAccounting> ContractAccountingChecksStates { get; set; } = new List<ContractAccounting>();

    [InverseProperty("InvoiceState")]
    public virtual ICollection<ContractAccounting> ContractAccountingInvoiceStates { get; set; } = new List<ContractAccounting>();

    [InverseProperty("CommercialState")]
    public virtual ICollection<ContractContact> ContractContactCommercialStates { get; set; } = new List<ContractContact>();

    [InverseProperty("ConfirmationsState")]
    public virtual ICollection<ContractContact> ContractContactConfirmationsStates { get; set; } = new List<ContractContact>();

    [InverseProperty("CreditState")]
    public virtual ICollection<ContractContact> ContractContactCreditStates { get; set; } = new List<ContractContact>();

    [InverseProperty("NoticesState")]
    public virtual ICollection<ContractContact> ContractContactNoticesStates { get; set; } = new List<ContractContact>();

    [InverseProperty("SchedulingState")]
    public virtual ICollection<ContractContact> ContractContactSchedulingStates { get; set; } = new List<ContractContact>();

    [InverseProperty("CheckPaymentState")]
    public virtual ICollection<ContractExhibitC> ContractExhibitCs { get; set; } = new List<ContractExhibitC>();

    [InverseProperty("HqLocation")]
    public virtual ICollection<Counterparty> CounterpartyHqLocations { get; set; } = new List<Counterparty>();

    [InverseProperty("Jurisdiction")]
    public virtual ICollection<Counterparty> CounterpartyJurisdictions { get; set; } = new List<Counterparty>();

    [InverseProperty("State")]
    public virtual ICollection<Counterparty> CounterpartyStates { get; set; } = new List<Counterparty>();

    [InverseProperty("State")]
    public virtual ICollection<County> Counties { get; set; } = new List<County>();

    [InverseProperty("CounterpartyState")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeCounterpartyStates { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("InternalEntityState")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeInternalEntityStates { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("CounterpartyState")]
    public virtual ICollection<InvoiceGa> InvoiceGaCounterpartyStates { get; set; } = new List<InvoiceGa>();

    [InverseProperty("InternalEntityState")]
    public virtual ICollection<InvoiceGa> InvoiceGaInternalEntityStates { get; set; } = new List<InvoiceGa>();

    [InverseProperty("State")]
    public virtual ICollection<Meter> Meters { get; set; } = new List<Meter>();

    [InverseProperty("BankAchState")]
    public virtual ICollection<PaymentInstruction> PaymentInstructionBankAchStates { get; set; } = new List<PaymentInstruction>();

    [InverseProperty("BankState")]
    public virtual ICollection<PaymentInstruction> PaymentInstructionBankStates { get; set; } = new List<PaymentInstruction>();

    [InverseProperty("BankWireState")]
    public virtual ICollection<PaymentInstruction> PaymentInstructionBankWireStates { get; set; } = new List<PaymentInstruction>();

    [InverseProperty("State")]
    public virtual ICollection<Point> Points { get; set; } = new List<Point>();

    [InverseProperty("State")]
    public virtual ICollection<SalesTaxExemption> SalesTaxExemptions { get; set; } = new List<SalesTaxExemption>();

    [InverseProperty("State")]
    public virtual ICollection<SeveranceTax> SeveranceTaxes { get; set; } = new List<SeveranceTax>();

    [InverseProperty("State")]
    public virtual ICollection<StateIncomeExemption> StateIncomeExemptions { get; set; } = new List<StateIncomeExemption>();
}
