using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("state_income_exemption_doc")]
[Index("StateIncomeExemptionId", "FileNameOnDisk", Name = "uk_state_income_exemption_doc", IsUnique = true)]
public partial class StateIncomeExemptionDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("state_income_exemption_id")]
    public int StateIncomeExemptionId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("StateIncomeExemptionId")]
    [InverseProperty("StateIncomeExemptionDocs")]
    public virtual StateIncomeExemption StateIncomeExemption { get; set; } = null!;
}
