using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("settle_type")]
public partial class SettleType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("SettleType")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
