using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("sales_tax_rate")]
public partial class SalesTaxRate
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("rate")]
    public decimal Rate { get; set; }

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [Column("county_id")]
    public int CountyId { get; set; }

    [ForeignKey("CountyId")]
    [InverseProperty("SalesTaxRates")]
    public virtual County County { get; set; } = null!;
}
