using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("point")]
public partial class Point
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("point_description", TypeName = "citext")]
    public string? PointDescription { get; set; }

    [Column("pipeline_id")]
    public int? PipelineId { get; set; }

    [Column("zone_id")]
    public int? ZoneId { get; set; }

    [Column("basis_location_id", TypeName = "citext")]
    public string? BasisLocationId { get; set; }

    [Column("state_id")]
    public int? StateId { get; set; }

    [Column("client_id")]
    public int? ClientId { get; set; }

    [Column("is_active")]
    public bool IsActive { get; set; }

    [Column("latitude")]
    public double? Latitude { get; set; }

    [Column("longitude")]
    public double? Longitude { get; set; }

    [Column("address_line1", TypeName = "citext")]
    public string? AddressLine1 { get; set; }

    [Column("address_line2", TypeName = "citext")]
    public string? AddressLine2 { get; set; }

    [Column("city", TypeName = "citext")]
    public string? City { get; set; }

    [Column("zip_code", TypeName = "citext")]
    public string? ZipCode { get; set; }

    [Column("product_ids", TypeName = "citext")]
    public string ProductIds { get; set; } = null!;

    [InverseProperty("Point")]
    public virtual ICollection<CrudeMarket> CrudeMarkets { get; set; } = new List<CrudeMarket>();

    [InverseProperty("Point")]
    public virtual ICollection<CrudePathRoute> CrudePathRoutes { get; set; } = new List<CrudePathRoute>();

    [InverseProperty("Point")]
    public virtual ICollection<CrudeSupply> CrudeSupplies { get; set; } = new List<CrudeSupply>();

    [InverseProperty("Point")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();

    [InverseProperty("Point")]
    public virtual ICollection<GasMarket> GasMarkets { get; set; } = new List<GasMarket>();

    [InverseProperty("Point")]
    public virtual ICollection<GasPathRoute> GasPathRoutes { get; set; } = new List<GasPathRoute>();

    [InverseProperty("Point")]
    public virtual ICollection<GasSupply> GasSupplies { get; set; } = new List<GasSupply>();

    [InverseProperty("Point")]
    public virtual ICollection<MeterProductDeliveryPoint> MeterProductDeliveryPoints { get; set; } = new List<MeterProductDeliveryPoint>();

    [InverseProperty("Point")]
    public virtual ICollection<MeterProductSourcePoint> MeterProductSourcePoints { get; set; } = new List<MeterProductSourcePoint>();

    [ForeignKey("PipelineId")]
    [InverseProperty("Points")]
    public virtual Pipeline? Pipeline { get; set; }

    [InverseProperty("Point")]
    public virtual ICollection<PointProductGradeToIndex> PointProductGradeToIndices { get; set; } = new List<PointProductGradeToIndex>();

    [InverseProperty("Point")]
    public virtual ICollection<PointSourceDelivery> PointSourceDeliveries { get; set; } = new List<PointSourceDelivery>();

    [InverseProperty("AutoSelectPoint")]
    public virtual ICollection<SosGasSetting> SosGasSettings { get; set; } = new List<SosGasSetting>();

    [InverseProperty("DeliveryPoint")]
    public virtual ICollection<SosHiddenDeal> SosHiddenDealDeliveryPoints { get; set; } = new List<SosHiddenDeal>();

    [InverseProperty("ReceiptPoint")]
    public virtual ICollection<SosHiddenDeal> SosHiddenDealReceiptPoints { get; set; } = new List<SosHiddenDeal>();

    [InverseProperty("Point")]
    public virtual ICollection<SosSnapshot> SosSnapshots { get; set; } = new List<SosSnapshot>();

    [ForeignKey("StateId")]
    [InverseProperty("Points")]
    public virtual Territory? State { get; set; }

    [ForeignKey("ZoneId")]
    [InverseProperty("Points")]
    public virtual Zone? Zone { get; set; }
}
