using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("plant_note")]
[Index("PlantId", "Month", Name = "uk_plant_note", IsUnique = true)]
public partial class PlantNote
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("plant_id")]
    public int PlantId { get; set; }

    [Column("month")]
    public DateOnly Month { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("PlantId")]
    [InverseProperty("PlantNotes")]
    public virtual Plant Plant { get; set; } = null!;
}
