using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipe_rate_application_rule")]
public partial class PipeRateApplicationRule
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [InverseProperty("ApplicationRule")]
    public virtual ICollection<PipelineTariff> PipelineTariffs { get; set; } = new List<PipelineTariff>();
}
