using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("pipe_discount_doc")]
public partial class PipeDiscountDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipeline_rate_discounted_id")]
    public int PipelineRateDiscountedId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("PipelineRateDiscountedId")]
    [InverseProperty("PipeDiscountDocs")]
    public virtual PipelineRateDiscounted PipelineRateDiscounted { get; set; } = null!;
}
