using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Index("ApplicationId", "Status", "Subject", "Type", Name = "idx_26793_IX_OpenIdAuth_App_Status_Subject_Type")]
public partial class OpenIddictAuthorization
{
    [Key]
    [Column(TypeName = "citext")]
    public string Id { get; set; } = null!;

    [Column(TypeName = "citext")]
    public string? ApplicationId { get; set; }

    [Column(TypeName = "citext")]
    public string? ConcurrencyToken { get; set; }

    public DateTime? CreationDate { get; set; }

    [Column(TypeName = "citext")]
    public string? Properties { get; set; }

    [Column(TypeName = "citext")]
    public string? Scopes { get; set; }

    [Column(TypeName = "citext")]
    public string? Status { get; set; }

    [Column(TypeName = "citext")]
    public string? Subject { get; set; }

    [Column(TypeName = "citext")]
    public string? Type { get; set; }

    [ForeignKey("ApplicationId")]
    [InverseProperty("OpenIddictAuthorizations")]
    public virtual OpenIddictApplication? Application { get; set; }

    [InverseProperty("Authorization")]
    public virtual ICollection<OpenIddictToken> OpenIddictTokens { get; set; } = new List<OpenIddictToken>();
}
