using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("meter_type")]
[Index("Name", Name = "uk_meter_type", IsUnique = true)]
public partial class MeterType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("default_color", TypeName = "citext")]
    public string? DefaultColor { get; set; }

    [Column("default_unit_of_measure_id")]
    public int? DefaultUnitOfMeasureId { get; set; }

    [ForeignKey("DefaultUnitOfMeasureId")]
    [InverseProperty("MeterTypes")]
    public virtual UnitOfMeasure? DefaultUnitOfMeasure { get; set; }

    [InverseProperty("MeterType")]
    public virtual ICollection<MeterProduct> MeterProducts { get; set; } = new List<MeterProduct>();
}
