using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("meter_product_source_point")]
[Index("MeterProductId", "PointId", Name = "uk_meter_product_point", IsUnique = true)]
public partial class MeterProductSourcePoint
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("meter_product_id")]
    public int MeterProductId { get; set; }

    [Column("point_id")]
    public int PointId { get; set; }

    [ForeignKey("MeterProductId")]
    [InverseProperty("MeterProductSourcePoints")]
    public virtual MeterProduct MeterProduct { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("MeterProductSourcePoints")]
    public virtual Point Point { get; set; } = null!;
}
