using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("market_index_publication")]
[Index("Name", Name = "uk_market_index_publication", IsUnique = true)]
public partial class MarketIndexPublication
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("Publication")]
    public virtual ICollection<MarketIndex> MarketIndices { get; set; } = new List<MarketIndex>();
}
