using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("deal_status")]
public partial class DealStatus
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("for_physical_gas")]
    public bool? ForPhysicalGas { get; set; }

    [Column("for_crude_oil")]
    public bool? ForCrudeOil { get; set; }

    [Column("for_power")]
    public bool? ForPower { get; set; }

    [Column("for_futures")]
    public bool? ForFutures { get; set; }

    [Column("for_options")]
    public bool? ForOptions { get; set; }

    [Column("for_basis_swaps")]
    public bool? ForBasisSwaps { get; set; }

    [Column("for_ff_swaps")]
    public bool? ForFfSwaps { get; set; }

    [Column("for_otc_swaps")]
    public bool? ForOtcSwaps { get; set; }

    [Column("for_ngls")]
    public bool? ForNgls { get; set; }

    [Column("for_transport")]
    public bool? ForTransport { get; set; }

    [InverseProperty("DealStatus")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
