using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("credit_limit_counterparty")]
[Index("CreditLimitId", "CounterpartyId", "ProductCategoryId", Name = "uk_credit_limit_counterparty", IsUnique = true)]
public partial class CreditLimitCounterparty
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("credit_limit_id")]
    public int CreditLimitId { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("credit_limit_amount")]
    public decimal? CreditLimitAmount { get; set; }

    [Column("product_category_id")]
    public int ProductCategoryId { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("CreditLimitCounterparties")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("CreditLimitId")]
    [InverseProperty("CreditLimitCounterparties")]
    public virtual CreditLimit CreditLimit { get; set; } = null!;

    [InverseProperty("CreditLimitCounterparty")]
    public virtual ICollection<CreditLimitCollateral> CreditLimitCollaterals { get; set; } = new List<CreditLimitCollateral>();

    [ForeignKey("ProductCategoryId")]
    [InverseProperty("CreditLimitCounterparties")]
    public virtual ProductCategory ProductCategory { get; set; } = null!;
}
