using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("credit_limit_collateral_provider")]
[Index("CreditLimitCollateralId", "ProviderId", Name = "uk_credit_limit_collateral_provider_collateral", IsUnique = true)]
public partial class CreditLimitCollateralProvider
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("credit_limit_collateral_id")]
    public int CreditLimitCollateralId { get; set; }

    [Column("provider_id")]
    public int ProviderId { get; set; }

    [ForeignKey("CreditLimitCollateralId")]
    [InverseProperty("CreditLimitCollateralProviders")]
    public virtual CreditLimitCollateral CreditLimitCollateral { get; set; } = null!;

    [ForeignKey("ProviderId")]
    [InverseProperty("CreditLimitCollateralProviders")]
    public virtual Counterparty Provider { get; set; } = null!;
}
