using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("credit_limit_approval")]
[Index("CreditLimitId", "FileNameOriginal", Name = "uk_credit_limit_approval", IsUnique = true)]
public partial class CreditLimitApproval
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("credit_limit_id")]
    public int CreditLimitId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string? FileNameOnDisk { get; set; }

    [ForeignKey("CreditLimitId")]
    [InverseProperty("CreditLimitApprovals")]
    public virtual CreditLimit CreditLimit { get; set; } = null!;
}
