using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_doc")]
public partial class ContractDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractDocs")]
    public virtual Contract Contract { get; set; } = null!;
}
